* 04 Figures 2-3.do;  * uses altb imputations.;
*version 17
#d ;
clear;
cap log close;
set more off;
set type double;
set scheme s1color;
pause on;

log using "${log}04 Figures 2-3.log", replace;
use "${CE}/ce_cpc_comb_haall_v7.dta", clear;
count;

***************;
* to match CE we should exclude 7 states FIPS 19,35,38,50,56,44,40 where there is no CE data.
* unfortunately our CPSP data does not include State so we cannot.  So the samples will differ.;

* compute scalars to add pov line to the density picture in year xyear;  * fam2A2C for 2Adult2Child families;
*local xyear=2019;
gen c_fam2A2C =c_nadult==2 & c_nchild==2;

sum c_rspm_thres [aweight=c_perpopwt] if c_fam2A2C==1 & asecsurvey==0;
scalar pline1= r(mean);

sum c_rspm_thres [aweight=c_perpopwt] if asecsurvey==0;
scalar pline3= r(mean);

* compute pov line with mean adjustment for spec check;
sum c_radjustments [aweight=c_perpopwt] if c_fam2A2C==1 &ce_princ_noadj==1;
scalar madj=r(mean);
scalar pline2=pline1+madj;
scalar list;

* after tax with SNAP;
gen c_rinc_aftertax=c_rfinc_addfsm-c_rtaxm2;
gen c_poor_rinc_aftertax=c_rinc_aftertax<c_rspm_thres if c_rspm_thres<.;

* compare gross resource distributions for entire pop;
kdensity c_rinc_aftertax [aweight=c_perpopwt] if asecsurvey==1 &  inlist(year,2017,2018,2019) , n(300) gen(rasecinc0_x rasecinc0_d);
kdensity c_rfinc_nofsm [aweight=c_perpopwt] if asecsurvey==0 & inlist(year,2017,2018,2019) , n(300) gen(rceinc0_x rceinc0_d);
kdensity ce_rexp_noadj [aweight=c_perpopwt] if inlist(year,2017,2018,2019), n(300) gen(rexp0_x rexp0_d);

* Fig 2, Gross resources for CE and ASEC;
twoway  
(line rexp0_d rexp0_x if rexp0_x<250000 & rexp0_x>0, color(red))
(line rasecinc0_d rasecinc0_x if rasecinc0_x<250000 & rasecinc0_x>0, color(blue)) ,  
title("Figure 2: Distribution of Gross CE Spending and" "Gross Adjusted CPS Income, 2017–2019" " ", size(11pt))  ytitle("Kernel Density" " ") ylabel(,format(%10.1e) labsize(small)) xlabel(,format(%12.0fc) labsize(small)) 
legend(label(1  "Gross CE Spending")  label(2 "Gross Adjusted CPS Income") size(small)) xline(`=scalar(pline3)', lpattern(dash) lcolor(black)) 
note("Notes: Gross CE Spending is total household spending on all items in the year. Gross Adjusted CPS Income is total income in the year after-tax" "and with SNAP benefits added. Dashed line denotes average threshold.", size(vsmall) span)
saving("${outgraph}04 Gross Resources 2017-2019 (Figure 2 C).gph",replace);
graph export "${outgraph}04 Gross Resources 2017-2019 (Figure 2 C).pdf",replace;
*table [aweight=c_perpopwt] if year==`xyear' &asecsurvey==0, stat(median c_rfinc_nofsm ce_rexp_noadj) ;
*table [aweight=c_perpopwt] if year==`xyear' &asecsurvey==1, stat(median c_rfinc_nofsm) ;

twoway  
(line rexp0_d rexp0_x if rexp0_x<250000 & rexp0_x>0, color(gray))
(line rasecinc0_d rasecinc0_x if rasecinc0_x<250000 & rasecinc0_x>0, color(gray%50)) ,  
title("Figure 2: Distribution of Gross CE Spending and" "Gross Adjusted CPS Income, 2017–2019" " ", size(11pt))  ytitle("Kernel Density" " ") ylabel(,format(%10.1e) labsize(small)) xlabel(,format(%12.0fc) labsize(small)) 
legend(label(1  "Gross CE Spending")  label(2 "Gross Adjusted CPS Income") size(small)) xline(`=scalar(pline3)', lpattern(dash) lcolor(black)) 
note("Notes: Gross CE Spending is total household spending on all items in the year. Gross Adjusted CPS Income is total income in the year after-tax" "and with SNAP benefits added. Dashed line denotes average threshold.", size(vsmall) span)
saving("${outgraph}04 Gross Resources 2017-2019 (Figure 2 BW).gph",replace);
graph export "${outgraph}04 Gross Resources 2017-2019 (Figure 2 BW).pdf",replace;

* Fig 3, Gross/Net Income and Expenditure;
* Generate net income and expenditures;
* Net in-kind transfers and costs of work and health insurance are subtracted;
gen c_rinc_aftertax_net = (c_rinc_aftertax) + (c_rinkind) - (c_rchildsupport + c_rCapWknChCareXpns + c_rhealth) ; 
kdensity c_rinc_aftertax_net [aweight=c_perpopwt] if asecsurvey==1 &  inlist(year,2017,2018,2019) , n(300) gen(rasecinc1_x rasecinc1_d);
kdensity c_rexpk [aweight=c_perpopwt] if inlist(year,2017,2018,2019), n(200) gen(rexp1_x rexp1_d);

twoway  
(line rexp0_d rexp0_x if rexp0_x<250000 & rexp0_x>0, color(red)) 
(line rasecinc0_d rasecinc0_x if rasecinc0_x<250000 & rasecinc0_x>0, color(blue)) 
(line rexp1_d rexp1_x if rexp1_x<250000 & rexp1_x>0, color(red%50) lpattern(dash_dot)) 
(line rasecinc1_d rasecinc1_x if rasecinc1_x<250000 & rasecinc1_x>0, color(blue%50) lpattern(dash_dot)) ,
title("Figure 3: Gross and Net CE Spending and" "Adjusted CPS Income, 2017-2019" " ", size(11pt))  ytitle("Kernel Density" " ") ylabel(,format(%10.1e) labsize(small)) xlabel(,format(%12.0fc) labsize(small)) 
legend(label(1  "Gross CE Spending")  label(2 "Gross Adjusted CPS Income") label(3 "Net CE Spending") label(4 "Net Adjusted CPS Income") size(small)) 
xline(`=scalar(pline3)', lpattern(dash) lcolor(black)) 
note("Notes: Gross CE Spending is total household spending on all items in the year. Gross Adjusted CPS Income is total income in the year after-tax" "and with SNAP benefits added. Net measures include four in-kind transfers and exclude three types of capped adjustments (work-related and" "child care costs, child support paid, and medical out of pocket expense). Dashed line denotes average threshold.", size(vsmall) span)
saving("${outgraph}04 Gross and Adjusted Resources 2017-2019 (Figure 3 C).gph",replace);
graph export "${outgraph}04 Gross and Adjusted Resources 2017-2019 (Figure 3 C).pdf",replace;
*table [aweight=c_perpopwt] if year==`xyear', stat(mean ce_princ_noadj ce_prexp_noadj ce_princk_tmwc ce_prexpk_fmwc) ;


twoway  
(line rexp0_d rexp0_x if rexp0_x<250000 & rexp0_x>0, color(gray)) 
(line rasecinc0_d rasecinc0_x if rasecinc0_x<250000 & rasecinc0_x>0, color(gray%50)) 
(line rexp1_d rexp1_x if rexp1_x<250000 & rexp1_x>0, color(gray) lpattern(dash_dot)) 
(line rasecinc1_d rasecinc1_x if rasecinc1_x<250000 & rasecinc1_x>0, color(gray%50) lpattern(dash_dot)) ,
title("Figure 3: Gross and Net CE Spending and" "Adjusted CPS Income, 2017-2019" " ", size(11pt))  ytitle("Kernel Density" " ") ylabel(,format(%10.1e) labsize(small)) xlabel(,format(%12.0fc) labsize(small)) 
legend(label(1  "Gross CE Spending")  label(2 "Gross Adjusted CPS Income") label(3 "Net CE Spending") label(4 "Net Adjusted CPS Income") size(small)) 
xline(`=scalar(pline3)', lpattern(dash) lcolor(black)) 
note("Notes: Gross CE Spending is total household spending on all items in the year. Gross Adjusted CPS Income is total income in the year after-tax" "and with SNAP benefits added. Net measures include four in-kind transfers and exclude three types of capped adjustments (work-related and" "child care costs, child support paid, and medical out of pocket expense). Dashed line denotes average threshold.", size(vsmall) span)
saving("${outgraph}04 Gross and Adjusted Resources 2017-2019 (Figure 3 BW).gph",replace);
graph export "${outgraph}04 Gross and Adjusted Resources 2017-2019 (Figure 3 BW).pdf",replace;

log close;
set scheme s2color ;

